/*=========================================================================
 Copyright (c), 1991-2007, T&W ELECTRONICS(SHENTHEN) Co., Ltd.
 ļ : flash_layout_kernel.c
 ļ : flash layoutز

 б :
				sysdata_get
				sysdata_save
				item_get
				item_save
				item_repeat
				flash_update_bin
				flash_update_img				

 ޶¼ :
          1  : 
             : 2008-7-22
             :

          2 ޶: 
             : 2008-9-10
             : ϢΪĿ

           3 ޶: 
             : 2009-2-18
             : BIN file

           4 ޶: 
             : 2009-3-16
             : ŻĿĲ

           5 ޶: 
             : 2009-5-18
             : Ż

           6޶: 
             : 2012-04-01
             : binļʱmib_rfMACssnĹ

=========================================================================*/

#include <linux/syscalls.h>
#include <linux/vmalloc.h>
#include <linux/flash_layout_kernel.h>
#include "autoconf.h"

#define READ_ITEM_LEN ( 0x1000 )
#define MAX_FLASH_LEN (3932159)    //4M-256K

extern char *nvram_get(char *name);

#ifdef CONFIG_FLASH_WRITE_PROTECT
 extern char kernal_flash_protect(char isEnable);
#endif
/*add by huangshuangbang 20120602 for save mib_rf and mac when update bin end*/

#ifdef CONFIG_APPS_LOGIC_NMRP
/*add by wyh start at 20140624 to add WIFI NMRP upgrade wirte flash interface*/
mm_segment_t		 g_fs;
struct mtd_info		*g_mtd;
struct mtd_part		*g_part ;
flash_info_t		*g_info;
sys_config_t		*g_sys_data;
update_hdr_t		*g_update_hdr;
unsigned int		 g_start = 0 ;
unsigned int		 g_end = 0;
/*add by wyh end*/
#endif


#if 1
#define mib_debug printk
#else
#define mib_debug
#endif

#if 1 //song

struct FactoryCfg
{
	char szSsidRandom[3];
	char szPassPhase[65];
	char szSsid[33];
	char szSn[128];
	//char szPin[9];
	char sztbscfg[32*1024];
	unsigned short sztbscfgLen;
};

static void  FactoryCfg_get(struct FactoryCfg *data);
static void  FactoryCfg_set(struct FactoryCfg *data);
static void  llconfig_get_syscfg(llconfig_syscfg_t *data);
static void  llconfig_set_syscfg(llconfig_syscfg_t *data);

static struct FactoryCfg  stFactoryCfg;
static llconfig_syscfg_t stsyscfg;


/*=========================================================================
 Function:		void  mib_rf_config_get(  mib_rf *data)
 Description:		ȡmib_rf ֵԱbinʱָ
 Data Accessed:
 Data Updated:
 Input:		
 Output:			*data:		ȡmib_rfֵ
 Return:			
 Others:
=========================================================================*/

static void  FactoryCfg_get(  struct FactoryCfg *data)
{
	unsigned short len = 5;

    len = sizeof(data->szSsidRandom);
	if(ERROR_ITEM_NOT_FIND == item_get(data->szSsidRandom, "WLAN_SSID_RANDOM",&len))
	{
		memset(data->szSsidRandom, 0, sizeof(data->szSsidRandom) );
	}
	else
	{
		data->szSsidRandom[len] = '\0';
	}

	len = sizeof(data->szPassPhase);
	if(ERROR_ITEM_NOT_FIND == item_get(data->szPassPhase, "WLAN_PASSPHRSE_RANDOM",&len))
	{
		memset(data->szPassPhase, 0, sizeof(data->szPassPhase) );
	}
	else
	{
		data->szPassPhase[len] = '\0';
	}

	len = sizeof(data->szSsid);
	if(ERROR_ITEM_NOT_FIND == item_get(data->szSsid, "ssid",&len))
	{
		memset(data->szSsid, 0, sizeof(data->szSsid) );
	}
	else
	{
		data->szSsid[len] = '\0';
	}

	len = sizeof(data->szSn);
	if(ERROR_ITEM_NOT_FIND == item_get(data->szSn, "PRODUCT_SN",&len))
	{
		memset(data->szSn, 0, sizeof(data->szSn) );
		
	}
	else
	{
		data->szSn[len] = '\0';
	}

	len = sizeof(data->sztbscfg);
	if(ERROR_ITEM_NOT_FIND == item_get(data->sztbscfg, TBS_APP_CFG,&len))
	{
	    mib_debug("[FactoryCfg_get]get TBS_APP_CFG info fail!!\n");
		memset(data->sztbscfg, 0, sizeof(data->sztbscfg) );
		data->sztbscfgLen=0;
	}
	else
	{
	    mib_debug("[FactoryCfg_get]get TBS_APP_CFG info len = %d!!\n",len);
		data->sztbscfg[len] = '\0';
		data->sztbscfgLen = len;
	}
		
}
static void  FactoryCfg_set(  struct FactoryCfg *data)
{
	unsigned short len;

	len = strlen(data->szSsidRandom);
	if(ERROR_ITEM_OK != item_save(data->szSsidRandom, "WLAN_SSID_RANDOM",len))
	{
		mib_debug("[FactoryCfg_set]set WLAN_SSID_RANDOM info fail!!\n");
	}

	len = strlen(data->szPassPhase);
	if(ERROR_ITEM_OK != item_save(data->szPassPhase, "WLAN_PASSPHRSE_RANDOM",len))
	{
		mib_debug("[FactoryCfg_set]set WLAN_PASSPHRSE_RANDOM info fail!!\n");
	}

	len = strlen(data->szSsid);
	if(ERROR_ITEM_OK != item_save(data->szSsid, "ssid",len))
	{
		mib_debug("[FactoryCfg_set]set ssid info fail!!\n");
	}

	len = strlen(data->szSn);
	if(ERROR_ITEM_OK != item_save(data->szSn, "PRODUCT_SN",len))
	{
		mib_debug("[FactoryCfg_set]set SN info fail!!\n");
	}
	
	len = strlen(data->sztbscfg);
	mib_debug("[FactoryCfg_set]set TBS_APP_CFG info len = %d!!\n",len);
	len = data->sztbscfgLen;
	mib_debug("[FactoryCfg_set]set TBS_APP_CFG info len = %d!!\n",len);
	if(ERROR_ITEM_OK != item_save(data->sztbscfg, TBS_APP_CFG,len))
	{
		mib_debug("[FactoryCfg_set]set TBS_APP_CFG info fail!!\n");
	}
	else
	{
        mib_debug("[FactoryCfg_set]set TBS_APP_CFG info len = %d!!\n",len);
	}

		
}	

/*=========================================================================
 Function:		void  llconfig_get_syscfg(  llconfig_syscfg_t *data)
 Description:		ȡMACֵ
 Data Accessed:
 Data Updated:
 Input:		       
 Output:			*data:	ȡMACֵ
 Return:			
 Others:
=========================================================================*/
static void  llconfig_get_syscfg(  llconfig_syscfg_t *data)
{
	sys_config_t syscfg;
	int i;

	sysdata_get( &syscfg);
	for(i = 0; i < 6; i++)
	{
		data->mac[i] = syscfg.mac[i];
	}
	/*ȡǩ*/
	memcpy(data->mac, syscfg.mac, 6);	
    memcpy(data->board_id, syscfg.board_id, BOARD_ID_NAME_LEN);
	memcpy(data->region, syscfg.region, REGION_LEN);
	memcpy(data->gui_region, syscfg.gui_region, GUI_REGION_LEN);
	memcpy(data->pinandother, syscfg.pinandother, PINANDOTHER_LEN);
#ifdef CONFIG_DRIVER_PLC	
	memcpy(data->plc_npw, syscfg.plc_npw, PLC_NPW_LEN);
	memcpy(data->plc_dpw, syscfg.plc_dpw, PLC_DPW_LEN);
#endif	
}


/*=========================================================================
 Function:		void  llconfig_set_syscfg(  llconfig_syscfg_t *data)
 Description:		ָMACֵ
 Data Accessed:
 Data Updated:
 Input:		       *data:	ָMACֵ
 Output:			
 Return:			
 Others:
=========================================================================*/
static void  llconfig_set_syscfg(  llconfig_syscfg_t *data)
{
	int i;
	sys_config_t syscfg_tmp;
	char mac_and = data->mac[0] & data->mac[1] & data->mac[2] & data->mac[3] & data->mac[4] & data->mac[5];
	char mac_or   = data->mac[0] | data->mac[1] | data->mac[2] | data->mac[3] | data->mac[4] | data->mac[5];

	memset(&syscfg_tmp, 0, sizeof(sys_config_t));
	sysdata_get(&syscfg_tmp);
	if(0xFF == mac_and || 0x00 == mac_or)
	{
		printk("Illegal mac address, recover fail!!!\n");
	}
	else
	{
		for(i = 0; i < 6; i++)
		{
			syscfg_tmp.mac[i] = data->mac[i];
		}
	}

	/*ǩһ򲻻ᱣԻƷܻɰӹҵ*/
	if(0 == memcmp(syscfg_tmp.board_id, data->board_id, strlen(syscfg_tmp.board_id)))
	{
		//go ahead
		printk("===<The special parameter will be save>\n");
	}
	else
	{
		printk("===<The special parameter will not be saved !!!>\n");
		return;
	}

	memcpy(syscfg_tmp.mac, data->mac, 6);
	memcpy(syscfg_tmp.region, data->region, REGION_LEN);
	memcpy(syscfg_tmp.gui_region, data->gui_region, GUI_REGION_LEN);
	memcpy(syscfg_tmp.pinandother, data->pinandother, PINANDOTHER_LEN);
#ifdef CONFIG_DRIVER_PLC	
	memcpy(syscfg_tmp.plc_npw, data->plc_npw, PLC_NPW_LEN);
	memcpy(syscfg_tmp.plc_dpw, data->plc_dpw, PLC_DPW_LEN);
#endif
	
	sysdata_save(&syscfg_tmp);

}

#endif





/*=========================================================================
Ŀдź
=========================================================================*/

DECLARE_MUTEX(item_sem);



/*=========================================================================
 Function:		int  sysdata_get( sys_config_t* syscfg )
 Description:		ȡײllconfig
 Data Accessed:
 Data Updated:
 Input:			
 Output:			
 Return:			0:ɹ
				1:ʧ
 Others:
 				ô˺ǰΪsyscfgڴռ
=========================================================================*/

int  sysdata_get(sys_config_t* syscfg)
{
	unsigned short item_len;
	int ret;

	item_len = SYSCFG_SIZE;
	ret = item_get( syscfg, LLCONFIG_NAME , &item_len );
	if( ret == ERROR_ITEM_OK )
	{
		return 0;
	}
	return 1;
}

/*=========================================================================
 Function:		int  sysdata_save(sys_config_t * syscfg)
 Description:		ײllconfig
 Data Accessed:
 Data Updated:
 Input:			
 Output:			
 Return:			0:ɹ
				1:ʧ
 Others: 				
=========================================================================*/

int  sysdata_save(sys_config_t * 	syscfg)
{
	if( item_save( syscfg , LLCONFIG_NAME , SYSCFG_SIZE ) == ERROR_ITEM_OK )
	{
		return 0;
	}
	return 1;
}

/*=========================================================================
 Function:		int item_check( void )

 Description:		ÿĿ
 Data Accessed:
 Data Updated:
 Input:
 Output:
 Return:			ERROR_ITEM_OK
				ERROR_CONFIG_LOST
 Others:
=========================================================================*/

int item_check( flash_info_t* flash_info_low , struct mtd_info *mtd_master  )
{
	item_t			*item;
	unsigned short	checksum;
	unsigned int		i = 0;
	unsigned int		sum = 0;
	unsigned int		retlen;
	unsigned char		*item_sdram;

		/* ҵFlashʼַ*/	
	while( ( flash_info_low->start[i] - flash_info_low->start[0] ) < BOOTCODE_LENGTH )
		i++;
		
	item_sdram = vmalloc( flash_info_low->start[i+1] - flash_info_low->start[i] );
	if ( item_sdram == NULL )
	{		
		printk("item_sdram malloc wrong\n");
		
		return ERROR_ITEM_MALLOC;
	}
	
	mtd_master->read( mtd_master , flash_info_low->start[i] , (flash_info_low->start[i+1] - flash_info_low->start[i]) , &retlen, item_sdram );

	sum = CONFIG_MARK_LEN;
	while( ( sum + ITEM_HEAD_LEN ) <= ( flash_info_low->start[i+1] - flash_info_low->start[i] ) )
	{
		//mtd_master->read( mtd_master , flash_info_low->start[i] + sum , READ_ITEM_LEN , &retlen, item_sdram );
		
		item = ( item_t * ) ( item_sdram + sum );
		//item = ( item_t * ) ( item_sdram );
			
		if((((item->hdr.avail != 0xFF) &&(item->hdr.avail != ITEM_UNAVAIL) && (item->hdr.avail != ITEM_BAD) && (item->hdr.avail != ITEM_AVAIL ))||( item->hdr.len ==0)))
		{
			printk("[%s:%d]:avail=%0x,Error item, so recopy from backup setor.\n", __FUNCTION__, __LINE__,item->hdr.avail);
			vfree(item_sdram);
			return ERROR_CONFIG_LOST;
		}
		
		if( ( item->hdr.avail == ITEM_UNAVAIL ) )
		{
			sum += ITEM_SIZE( item->hdr.len );

			continue;
		}
		else if( item->hdr.avail == ITEM_BAD )
		{
			sum += ITEM_SIZE( 0 );

			continue;
		}
				
		/*ЧĿ*/
		else if( item->hdr.avail == ITEM_AVAIL )
		{
			tbs_crc16( item->data , item->hdr.len ,&checksum );
			if( checksum == item->hdr.crc )		/*Ŀ,ָһĿ*/
			{
				sum += ITEM_SIZE( item->hdr.len );

				continue;
			}
			else		/*Ŀ,ôĿΪЧ,ҿԿ϶һĿ*/
			{
				printk("[%s:%d]:Error item, so recopy from backup setor.\n", __FUNCTION__, __LINE__);
				vfree(item_sdram);
				return ERROR_CONFIG_LOST;
			}
		}

		else
		{
			/*Ŀ,ôĿΪЧ,ҿԿ϶һĿ*/
			if( check_addr_null( ( unsigned int * )item , (flash_info_low->start[i+1] - flash_info_low->start[i]-sum), mtd_master) == 1 )
			{
				printk("[%s:%d]:Error item, so recopy from backup setor.\n", __FUNCTION__, __LINE__);
				vfree(item_sdram);
				return ERROR_CONFIG_LOST;
			}
			else /*϶һĿ*/
				break;
		}
	}

	vfree(item_sdram);
	return ERROR_ITEM_OK;
}

#define CONFIGURE_BLOCK_CHECK 1

#ifdef CONFIGURE_BLOCK_CHECK

#define CONFIGBLOCK_SIZE (0x10000)
#define DEFAULT_LEN (1)
#define TEST_BEGIN      "xxxCONFbegin"
#define TEST_END        "xxxCONFend"

#define CONFIGURE_ITEM_NAME       "tbs_app_cfg"
#define CONFIGURE_ITEM_NAME_BAK   "tbs_app_cfg_bak"

/* ָĬϳ */

void ResetDefaultConfig()
{
	
	char *pcCfg = NULL;
	unsigned long ulLen = 0;
	int ret = 0;
 
	ulLen = DEFAULT_LEN * 1024;
	pcCfg = vmalloc(ulLen);
	
	if (NULL == pcCfg)
	{
		return ;
	}
	
	memset(pcCfg, 0, ulLen);//modify to malloc ok

	strcpy(pcCfg, TEST_BEGIN);
	strcpy(pcCfg + ulLen - sizeof(TEST_END), TEST_END);
	ret = item_save(pcCfg, CONFIGURE_ITEM_NAME, (unsigned short)ulLen);// ɾǰ
	if (0 != ret)
	{
		vfree(pcCfg);
		return ;
	}

	/*  */
	ret = item_save(pcCfg, CONFIGURE_ITEM_NAME_BAK, (unsigned short)ulLen);// ɾ
	
	/* ûָ־ */
	ret = item_save("1", TBS_RESET_FLAG, 2);
	
	/* ҳָҳ add sdh 2014-7-8*/
	ret = item_save("1", TBS_WiZARD_FLAG, 2);
	vfree(pcCfg);
	return ;
	
}
/*
Function:		int ConfigureBlock_EraseAndRecover()

 Description:		תָ
 Calls:			
 Data Accessed:
 Data Updated:
 Input:			
 Output:
 Return:		
 Others: ˺ȳԴȡllconfigĿ
         ʱȰȻתݸƵ
         0x40000-0x50000:
         0x50000-0x60000:ת
 		 0x60000-       : imgļʼ
*/

int ConfigureBlock_EraseAndRecover()
{
	unsigned int 			i = 0;
	mm_segment_t		fs;
	flash_info_t			*flash_info_low;
	struct mtd_info		*mtd;
	struct mtd_part		*part ;
	unsigned int			retlen;
    unsigned char			*item_sdram;
	
	fs = get_fs();
	set_fs (get_ds());

	/* ȡMTDϢ*/
	mtd = get_mtd_device( NULL, 0 );
	part = PART(mtd);
	
	flash_info_low = vmalloc( sizeof( flash_info_t ) );
	if ( flash_info_low == NULL )
	{
		printk(KERN_EMERG"flash_info_low malloc wrong\n");
		set_fs (fs);
		
		return ERROR_ITEM_MALLOC;
	}

	item_sdram = vmalloc( CONFIGBLOCK_SIZE );
	if ( item_sdram == NULL )
	{
			set_fs (fs);
			vfree( flash_info_low );
			
			printk("item_sdram malloc wrong\n");
			return ERROR_ITEM_MALLOC;
	}
	if(down_interruptible(&item_sem))
     {
              set_fs (fs);
              vfree(flash_info_low);
              vfree(item_sdram);
              printk("Item save fail,because flash is busy.\n");

              return ERROR_FLASH_BUSY;
     }

	/* ȡFlashб*/
	flash_info_get( flash_info_low ,  part->master );

	/* ҵFlashʼַ*/
	while( ( flash_info_low->start[i] - flash_info_low->start[0] ) < BOOTCODE_LENGTH )
		i++;

	/* */ 
    #ifdef CONFIG_FLASH_WRITE_PROTECT
			kernal_flash_protect(0);
    #endif
			kernel_erase( part->master , flash_info_low , flash_info_low->start[i] , flash_info_low->start[i+1] - flash_info_low->start[i] );
    #ifdef CONFIG_FLASH_WRITE_PROTECT
			kernal_flash_protect(1);
    #endif
	
	part->master->read( part->master , flash_info_low->start[i]+CONFIGBLOCK_SIZE, CONFIGBLOCK_SIZE , &retlen, item_sdram );


		/* transfer copy to config*/
#ifdef CONFIG_FLASH_WRITE_PROTECT
	kernal_flash_protect(0);
#endif
	kernel_write( part->master , item_sdram , flash_info_low->start[i] , CONFIGBLOCK_SIZE );
#ifdef CONFIG_FLASH_WRITE_PROTECT
	kernal_flash_protect(1);
#endif

    set_fs (fs);
	vfree( flash_info_low );
	vfree( item_sdram );
	up(&item_sem);
	
    /* ָĬϳ ,ݲָϴת*/
	//ResetDefaultConfig();

    return ERROR_ITEM_OK;
}
/*
Function:		int CheckTbsConfigBlock()

 Description:	check llconfigĿǷʹתлָ
 Calls:			
 Data Accessed:
 Data Updated:
 Input:			
 Output:
 Return:		
 Others: ˺ȳԴȡllconfigĿ
         ʱȰȻתݸƵ
 		
*/
int CheckTbsConfigBlock()
{
    sys_config_t syscfg;
	char *wl_ssid = NULL;
	char *wl_passphase = NULL;
	char *dpw_key = NULL;
	char *pin_code = NULL;
	char *product_sn = NULL;
	char *mac = NULL;
	char szPassPhase[65] = { 0 };
	char szSsid[33] = { 0 };
	char szSn[64] = { 0 };
	unsigned short ulen = 0; 
	int iCount = 0;
	char cMac[6] = { 0 };
	
	printk("call recoverSysdata_from_transfer()\n");
	if(1 == sysdata_get( &syscfg))
	{
        printk("configure block has broken!will recover from transfer Block.\n");
	}
	else
	{
		/*get factory param from nvram*/
		wl_ssid = nvram_get("wl_ssid");

		wl_passphase = nvram_get("wl_passphase");

		dpw_key = nvram_get("dpw_key");

		pin_code = nvram_get("pin_code");

		product_sn = nvram_get("product_sn");

		mac = nvram_get("et1macaddr");

		printk("\nnvram\n");
		printk("wl_ssid=%s\n", wl_ssid);
		printk("wl_passphase=%s\n", wl_passphase);
		printk("dpw_key=%s\n", dpw_key);
		printk("pin_code=%s\n", pin_code);
		printk("product_sn=%s\n", product_sn);
		printk("mac=%s\n", mac);

		/*if nvram is not empty*/
		if( (NULL != wl_ssid && strlen(wl_ssid) > 0) &&
		    (NULL != wl_passphase && strlen(wl_passphase) > 0) &&
			(NULL != dpw_key && strlen(dpw_key) > 0) &&
			(NULL != pin_code && strlen(pin_code) > 0) &&
			(NULL != product_sn && strlen(product_sn) > 0) &&
			(NULL != mac && strlen(mac) > 0)			
		  )
		{
			printk("\nsyscfg\n");
			
			ulen = sizeof(szSsid);
			item_get(szSsid, "ssid", &ulen);
			
			ulen = sizeof(szPassPhase);
			item_get(szPassPhase, "WLAN_PASSPHRSE_RANDOM", &ulen);
			
			ulen = sizeof(szSn);
			item_get(szSn, "PRODUCT_SN", &ulen);
			
			iCount = sscanf(mac, "%2hhx:%2hhx:%2hhx:%2hhx:%2hhx:%2hhx", 
				&cMac[0], &cMac[1], &cMac[2], &cMac[3], &cMac[4], &cMac[5]);

			printk("wl_ssid=%s\n", szSsid);
			printk("wl_passphase=%s\n", szPassPhase);
			printk("ndpw_key=%s\n", syscfg.plc_dpw);
			printk("model_name=%s\n", syscfg.model_name);
			printk("region_code=%s\n", syscfg.region);
			printk("pin_code=%s\n", syscfg.pinandother);
			printk("product_sn=%s\n", szSn);
			printk("mac=%02x:%02x:%02x:%02x:%02x:%02x\n", 
				cMac[0], cMac[1], cMac[2], cMac[3], cMac[4], cMac[5]);

			/*factory nvram comany with syscfg param*/
			if( (6 == iCount) &&
				(!strncmp(syscfg.model_name,"DST6501", 7)||
				 !strncmp(syscfg.model_name,"PLW1000v2", 9)||
				 !strncmp(syscfg.model_name,"PLW1010v2", 9))&& 
				(!strncmp(syscfg.region, "WW", 2)||
				 !strncmp(syscfg.region, "NA", 2)||
				 !strncmp(syscfg.region, "CA", 2)||
				 !strncmp(syscfg.region, "BZ", 2)||
				 !strncmp(syscfg.region, "ZA", 2)||
				 !strncmp(syscfg.region, "PR", 2)||
				 !strncmp(syscfg.region, "AU", 2)||
				 !strncmp(syscfg.region, "CN", 2)||
				 !strncmp(syscfg.region, "IL", 2)||
				 !strncmp(syscfg.region, "JP", 2)||
				 !strncmp(syscfg.region, "KO", 2)||
				 !strncmp(syscfg.region, "MX", 2)||
				 !strncmp(syscfg.region, "AE", 2)||
				 !strncmp(syscfg.region, "RU", 2)||
				 !strncmp(syscfg.region, "US", 2))&&
				(!strncmp(pin_code, syscfg.pinandother, 8)) &&
				(!memcmp(syscfg.mac, cMac, 6)))
			{
				printk("configure block is the same with nvram!\n");
		    	return 0;
			}
		}
		else/*if nvram is empty*/
		{	
			if((!strncmp(syscfg.model_name,"DST6501", 7)||
				 !strncmp(syscfg.model_name,"PLW1000v2", 9)||
				 !strncmp(syscfg.model_name,"PLW1010v2", 9))&&
				 (!strncmp(syscfg.region, "WW", 2)||
				 !strncmp(syscfg.region, "NA", 2)||
				 !strncmp(syscfg.region, "CA", 2)||
				 !strncmp(syscfg.region, "BZ", 2)||
				 !strncmp(syscfg.region, "ZA", 2)||
				 !strncmp(syscfg.region, "PR", 2)||
				 !strncmp(syscfg.region, "AU", 2)||
				 !strncmp(syscfg.region, "CN", 2)||
				 !strncmp(syscfg.region, "IL", 2)||
				 !strncmp(syscfg.region, "JP", 2)||
				 !strncmp(syscfg.region, "KO", 2)||
				 !strncmp(syscfg.region, "MX", 2)||
				 !strncmp(syscfg.region, "AE", 2)||
				 !strncmp(syscfg.region, "RU", 2)||
				 !strncmp(syscfg.region, "US", 2)))
			{
				printk("configure block is avalivable!\n");
				return 0;
			}
			else/*if model name and region is broken*/
			{
			    printk("configure model_name or region is broken!\n");
			}
		}
	}
    
	ConfigureBlock_EraseAndRecover();
    printk("configure block has recovered from transfer Block.\n");
	return 0;

}
#endif
/*=========================================================================
 Function:		int item_get( void *data , char *item_name ,unsigned short *len ) 

 Description:		ȡָĿ
 Calls:			
 Data Accessed:
 Data Updated:
 Input:			*item_name:	 Ŀ
 				*data:		ĿݵĴָ
 Output:			*len:		ĿЧݵĳ
 
 Return:			ERROR_ITEM_OK 
				ERROR_MALLOC
				ERROR_NOT_FIND
				ERROR_BIG
				ERROR_FLASH_BUSY
 Others:
 		ϲô˺ʱ*lenֵϲܽյ󳤶ȡ
  Чʵʳȴ*lendataͲֵҷش󣬲
 Ŀ Чݵĳͨ*lenϲ㡣
 ЧʵʳȲ*lenͽݸdataʵʳͨ
 *lenϲ
=========================================================================*/

int item_get( void *data , char *item_name ,unsigned short *len )
{
	item_t				*item;
	unsigned char			*item_sdram;
	unsigned int 			i = 0;
	unsigned int			sum = 0;
	mm_segment_t		fs;
	flash_info_t			*flash_info_low;
	struct mtd_info		*mtd;
	struct mtd_part		*part ;
	unsigned int			retlen;
	//printk("item_get() %s ERROR_ITEM_NOT_FIND______________________in\n",item_name);
	fs = get_fs();
	set_fs (get_ds());

	/* ȡMTDϢ*/
	mtd = get_mtd_device( NULL, 0 );
	part = PART(mtd);
		
	flash_info_low = vmalloc( sizeof( flash_info_t ) );
	if ( flash_info_low == NULL )
	{
		printk(KERN_EMERG"flash_info_low malloc wrong\n");
		set_fs (fs);
		
		return ERROR_ITEM_MALLOC;
	}

	/* ȡFlashб*/
	flash_info_get( flash_info_low ,  part->master );

	/* ҵFlashʼַ*/
	while( ( flash_info_low->start[i] - flash_info_low->start[0] ) < BOOTCODE_LENGTH )
		i++;

	item_sdram = vmalloc( READ_ITEM_LEN );
	if ( item_sdram == NULL )
	{
		set_fs (fs);
		vfree( flash_info_low );
		
		printk("item_sdram malloc wrong\n");
		
		return ERROR_ITEM_MALLOC;
	}

      if(down_interruptible(&item_sem))
      {
              set_fs (fs);
              vfree(flash_info_low);
              vfree(item_sdram);
              printk("Item get fail,because flash is busy.\n");
              
              return ERROR_FLASH_BUSY;
      }
  
	sum = CONFIG_MARK_LEN;

	/*ͨͷжǷ*/
	part->master->read( part->master , flash_info_low->start[i]  , READ_ITEM_LEN , &retlen, item_sdram );
	//printk("flash_info_low->start:%x %x\n",item_sdram[0],item_sdram[1]);
	if((item_sdram[0]!='O') || (item_sdram[1]!='K'))
    {
	    set_fs (fs);
		vfree(flash_info_low);
		vfree(item_sdram);
		up(&item_sem);
		return ERROR_ITEM_NOT_FIND;
    }
	
	
	/* Ŀ*/
	while( ( sum + ITEM_HEAD_LEN ) <= ( flash_info_low->start[i+1] - flash_info_low->start[i] ) )
	{
		part->master->read( part->master , flash_info_low->start[i] + sum , READ_ITEM_LEN , &retlen, item_sdram );
		item = ( item_t * ) item_sdram;
    #if 0
        if(0 == item->hdr.len)
        {
			set_fs (fs);
			vfree(flash_info_low);
			vfree(item_sdram);
			up(&item_sem);
			return ERROR_ITEM_NOT_FIND;
        }
    #endif
		/*ÿռѰ*/
		if( item->hdr.avail == 0xff )
		{
			break;
		}
		/*ĿЧ,ָһĿ*/
		else if( item->hdr.avail == ITEM_UNAVAIL )
		{
			sum += ITEM_SIZE( item->hdr.len );

			continue;
		}

		/*ĿѾǻ,ָһĿ*/
		else if( item->hdr.avail == ITEM_BAD )
		{
			sum += ITEM_SIZE( 0 );

			continue;
		}

		/* ҵЧĿ*/
		else if( item->hdr.avail == ITEM_AVAIL )
		{
			/* ԱĿ,жǷΪҪѰҵ*/
			if( strcmp( item->data , item_name ) == 0 )
			{
				/* ĿеݳǷϲڴռ*/
				if( ( item->hdr.len - strlen( item_name ) - 1 )  >  *len )
				{
					/* ,ʧܲʵҪĳ֪ͨϲ*/
					*len = item->hdr.len - strlen( item_name ) - 1;
					set_fs (fs);
					vfree(flash_info_low);
					vfree(item_sdram);
					up(&item_sem);
                    
					return ERROR_ITEM_BIG;					
				}
				else
				{
					/* ݶȡ*/
					*len = item->hdr.len - strlen( item_name ) - 1;
					
					if( ITEM_SIZE( item->hdr.len ) > READ_ITEM_LEN )
					{
						part->master->read( part->master , flash_info_low->start[i] + sum + ITEM_HEAD_LEN + strlen( item_name ) + 1 , *len , &retlen, ( unsigned char * )data );
					}
					else
					{
						memcpy( data, item->data + strlen( item_name ) + 1 , *len );						
					}

					set_fs (fs);
					vfree(flash_info_low);
					vfree(item_sdram);
                    up(&item_sem);
                   
                    //printk("item_get() %s len=%d______________________\n",item_name,*len);
					return ERROR_ITEM_OK;

				}
			}

			/*ҪҵĿ,Ѱ*/
			sum += ITEM_SIZE( item->hdr.len );
			continue;
		}
		
#ifdef CONFIGURE_BLOCK_CHECK		
		else
		{  
		    /*ߵ,sumֵӣѭһ쳣*/
		    printk("Error:item_get() line=%d sum = %d item_name=%s  \n",__LINE__,sum,item_name);
			set_fs (fs);
			vfree(flash_info_low);
			vfree(item_sdram);
			up(&item_sem);
            return ERROR_ITEM_NOT_FIND;	
		}
#endif		
	}

	set_fs (fs);
	vfree(flash_info_low);
	vfree(item_sdram);
	up(&item_sem);
    //printk("item_get() %s ERROR_ITEM_NOT_FIND______________________\n",item_name);
	return ERROR_ITEM_NOT_FIND;
}

/*=========================================================================
 Function:		int item_save( void *data , char *item_name ,unsigned short len ) 

 Description:		ȡָĿ

 Data Accessed:
 Data Updated:
 Input:			*item_name:	 Ŀ
 				*data:		ҪŵĿݵָ 				
				len:		ĿЧݵĳ
 Output:			
 Return:			ERROR_ITEM_OK 
				ERROR_ITEM_MALLOC				
				ERROR_ITEM_BIG
				ERROR_ITEM_REPEAT_FAIL
				ERROR_FLASH_BUSY
 Others:
=========================================================================*/
int item_save( void *data , char *item_name ,unsigned short len )
{
	item_t				*item;
	unsigned char			*item_sdram;
	unsigned int 			i = 0;
	unsigned int 			j = 0;
	unsigned int			sum = 0;
	item_t				*item_data;
	unsigned short		checksum;	
	char					avail;
	unsigned int			item_repeat_addr[2];

	mm_segment_t		fs;
	flash_info_t			*flash_info_low;
	struct mtd_info		*mtd;
	struct mtd_part		*part ;
	unsigned int			retlen;
    int iUnavailItemCnt = 0;
	
	fs = get_fs();
	set_fs (get_ds());

	/* ȡMTDϢ*/
	mtd = get_mtd_device( NULL, 0 );
	part = PART(mtd);
		
	flash_info_low = vmalloc( sizeof( flash_info_t ) );
	if ( flash_info_low == NULL )
	{
		printk(KERN_EMERG"flash_info_low malloc wrong\n");
		set_fs (fs);
		
		return ERROR_ITEM_MALLOC;
	}

	/* ȡFlashб*/
	flash_info_get( flash_info_low ,  part->master );

	/* ҵFlashʼַ*/
	while( ( flash_info_low->start[i] - flash_info_low->start[0] ) < BOOTCODE_LENGTH )
		i++;

	item_sdram = vmalloc(READ_ITEM_LEN );
	if ( item_sdram == NULL )
	{
		set_fs (fs);
		vfree( flash_info_low );
		
		printk("item_sdram malloc wrong\n");
		
		return ERROR_ITEM_MALLOC;
	}

      if(down_interruptible(&item_sem))
      {
              set_fs (fs);
              vfree(flash_info_low);
              vfree(item_sdram);
              printk("Item save fail,because flash is busy.\n");

          return ERROR_FLASH_BUSY;
     }
	//add by wyh start at 2016-01-30:УĿЧԣ֤ȷ²Žת
	if (item_check(flash_info_low, part->master) == ERROR_CONFIG_LOST)
	{
		part->master->read( part->master , flash_info_low->start[i+1], CONFIG_MARK_LEN , &retlen, item_sdram );

		if (!strcmp(item_sdram, CONFIG_MARK))
		{
			printk("[%s:%d]:Do the recopy operation from backup setor.\n", __FUNCTION__, __LINE__);
			/* */ 
			kernel_erase( part->master , flash_info_low , flash_info_low->start[i] , flash_info_low->start[i+1] - flash_info_low->start[i] );
			/* Ŀд*/
			kernel_write( part->master , ( char * )( flash_info_low->start[i+1] + CONFIG_MARK_LEN ) , flash_info_low->start[i] + CONFIG_MARK_LEN , flash_info_low->start[i+1] - flash_info_low->start[i]-CONFIG_MARK_LEN );
			kernel_write( part->master , CONFIG_MARK , flash_info_low->start[i] , CONFIG_MARK_LEN );	
		}
		else
		{
			printk("[%s:%d]:ERR---Repeat fail\n", __FUNCTION__, __LINE__);
			set_fs (fs);
            vfree(flash_info_low);
            vfree(item_sdram);
			up(&item_sem);
			return ERROR_ITEM_REPEAT_FAIL;
		}
	}
	//add by wyh end
      
	sum = CONFIG_MARK_LEN;

	/* Ѱҿõÿռ*/
	while( ( sum + ITEM_HEAD_LEN ) <= ( flash_info_low->start[i+1] - flash_info_low->start[i] ) )
	{
		part->master->read( part->master , flash_info_low->start[i] + sum , READ_ITEM_LEN , &retlen, item_sdram );
		item = ( item_t * ) item_sdram;

		/*ҵFLASHյַ*/
		if( item->hdr.avail == 0xff )
		{
			break;
		}
		
		else if( ( item->hdr.avail == ITEM_UNAVAIL ) )
		{
			sum += ITEM_SIZE( item->hdr.len );
            iUnavailItemCnt = iUnavailItemCnt + 1;
			continue;
		}

		else if( item->hdr.avail == ITEM_BAD )
		{
			sum += ITEM_SIZE( 0 );

			continue;
		}

		else if( item->hdr.avail == ITEM_AVAIL )
		{
			/*ֽҪΪЧĿ,ĵַ*/
			if( strcmp( item->data , item_name ) == 0 )
			{
				item_repeat_addr[j++] = flash_info_low->start[i] + sum + ( unsigned int )&( item->hdr.avail ) - ( unsigned int )item_sdram;

				/*ظĿ,ǰһĿΪЧ*/
				if( j == 2 )
				{
					avail = ITEM_UNAVAIL;
				#ifdef CONFIG_FLASH_WRITE_PROTECT
					kernal_flash_protect(0);
				#endif
					kernel_write( part->master , ( char * )&avail , item_repeat_addr[0] , 0x1 );
				#ifdef CONFIG_FLASH_WRITE_PROTECT
					kernal_flash_protect(1);
				#endif
					item_repeat_addr[0] = item_repeat_addr[1];
					j = 1;
				}
			}
			
			sum += ITEM_SIZE( item->hdr.len );

			continue;
		}	
		
#ifdef CONFIGURE_BLOCK_CHECK		
		else
		{  
		    /*ߵ,sumֵӣѭһ쳣*/
		    printk("Error:item_get() line=%d sum = %d item_name=%s \n",__LINE__,sum,item_name);
			set_fs (fs);
			vfree(flash_info_low);
			vfree(item_sdram);
			up(&item_sem);
            return ERROR_ITEM_NOT_FIND;	
		}
#endif	
	}

	/*ϢϳĿ*/
	item_data = vmalloc( ITEM_HEAD_LEN + strlen( item_name ) + 1 + len );
	if ( item_data == NULL )
	{
		set_fs (fs);
		vfree( flash_info_low );
		vfree( item_sdram );
		up(&item_sem);
		printk("item_data malloc wrong\n");
		
		return ERROR_ITEM_MALLOC;
	}

	item_data->hdr.avail = ITEM_AVAIL;	
	memcpy( item_data->data , item_name , strlen( item_name ) );
	memcpy( item_data->data + strlen( item_name ) , "\0" , 1 );	
	memcpy( item_data->data + strlen( item_name ) + 1 , data , len );	
	item_data->hdr.len = strlen( item_name ) + 1 + len;
	tbs_crc16( item_data->data , item_data->hdr.len ,&checksum );
	item_data->hdr.crc = checksum;

	/*жĿĴСǷ񳬳ʣռ*/
	if((iUnavailItemCnt > 10) || 
		( strcmp( LLCONFIG_NAME , item_name ) == 0 ) || 
		( strcmp( "WLAN_PASSPHRSE_RANDOM" , item_name ) == 0 ) || 
		( strcmp( "WLAN_SSID_RANDOM" , item_name ) == 0 ) || 
		( ITEM_SIZE( strlen( item_name ) + 1 + len ) > ( flash_info_low->start[i+1] - flash_info_low->start[i] - sum ) ))
	{
	    //printk("item_name = %s,call item_repeat()\n",item_name);
	    iUnavailItemCnt = 0;
		/*,ͨתķʽеЧͻĿ*/
		if( item_repeat( flash_info_low , part->master ) != ERROR_ITEM_REPEAT_OK )
		{
			set_fs (fs);
			vfree( flash_info_low );
			vfree( item_sdram );
			vfree( item_data );
			up(&item_sem);
            
			return ERROR_ITEM_REPEAT_FAIL;
		}
		
		j = 0;
		sum = CONFIG_MARK_LEN;

		/* תٴѰҿõÿռ*/
		while( ( sum + ITEM_HEAD_LEN ) <= ( flash_info_low->start[i+1] - flash_info_low->start[i] ) )
		{
			part->master->read( part->master , flash_info_low->start[i] + sum , READ_ITEM_LEN , &retlen, item_sdram );
			item = ( item_t * ) item_sdram;		

			/*ҵFLASHյַ*/
			if( item->hdr.avail == 0xff )
			{
				break;
			}

			else if( item->hdr.avail == ITEM_AVAIL )
			{
				/*ֽҪΪЧĿ,ĵַ*/
				if( strcmp( item->data , item_name ) ==0 )
				{
					item_repeat_addr[j++] = flash_info_low->start[i] + sum + ( unsigned int )&( item->hdr.avail ) - ( unsigned int )item_sdram;
				}
				
				sum += ITEM_SIZE( item->hdr.len );
				
				continue;
			}
#ifdef CONFIGURE_BLOCK_CHECK		
			else
			{  
			    /*ߵ,sumֵӣѭһ쳣*/
			    printk("Error:item_get() line=%d sum = %d item_name=%s  \n",__LINE__,sum,item_name);
				set_fs (fs);
				vfree(flash_info_low);
				vfree(item_sdram);
				up(&item_sem);
	            return ERROR_ITEM_NOT_FIND;	
			}
#endif	
		}
		
		/*ٴжǷ񳬳ռ*/
		if( ITEM_SIZE( item_data->hdr.len ) > ( flash_info_low->start[i+1] - flash_info_low->start[i] - sum ) )
		{
			/*Ŀ̫,޷,ش*/
			set_fs (fs);
			vfree( flash_info_low );
			vfree( item_sdram );
			vfree( item_data );
			up(&item_sem);
            
			return ERROR_ITEM_BIG;
		}
	}

	/* ϳɵĿдFlash*/
#ifdef CONFIG_FLASH_WRITE_PROTECT
	kernal_flash_protect(0);
#endif
	kernel_write( part->master , ( unsigned char * ) item_data , flash_info_low->start[i] + sum , ITEM_HEAD_LEN + item_data->hdr.len );
#ifdef CONFIG_FLASH_WRITE_PROTECT
	kernal_flash_protect(1);
#endif
	/* ĿΪЧ*/
	if( j == 1 )
	{
		avail = ITEM_UNAVAIL;
	#ifdef CONFIG_FLASH_WRITE_PROTECT
		kernal_flash_protect(0);
	#endif
		kernel_write( part->master , ( char * )&avail , item_repeat_addr[0] , 0x1 );
	#ifdef CONFIG_FLASH_WRITE_PROTECT
		kernal_flash_protect(1);
	#endif	
	}

	set_fs (fs);
	vfree( flash_info_low );
	vfree( item_sdram );
	vfree( item_data );
	up(&item_sem);
    //printk("item_save() %s len=%d______________________\n",item_name,len);
	return ERROR_ITEM_OK;
}

/*=========================================================================
 Function:		int item_repeat( flash_info_t* flash_info_low , struct mtd_info *mtd_master )

 Description:		ռ䲻ʱͨתתݣת
 				flashһڴ

 Data Accessed:
 Data Updated:
 Input:			
 				flash_info_low:	flashϢ
 				*mtd_master:		flash mtd
 				 				
 Output:			
 Return:			ERROR_ITEM_MALLOC				
				ERROR_ITEM_REPEAT_OK
 Others:
=========================================================================*/

int item_repeat( flash_info_t* flash_info_low , struct mtd_info *mtd_master )
{
	item_t			*item;
	unsigned int 		i = 0;
	unsigned int		sum = 0;
	unsigned int		len = 0;
	unsigned char		*item_sdram;
	unsigned int		addr;
	unsigned int		retlen;
#ifndef CONFIG_FLASH_TRANSFER
	unsigned char		*item_dram_repeat;
#endif

	/* ҵFlashʼַ*/	
	while( ( flash_info_low->start[i] - flash_info_low->start[0] ) < BOOTCODE_LENGTH )
		i++;

	item_sdram = vmalloc( READ_ITEM_LEN );
	if ( item_sdram == NULL )
	{		
		printk("item_sdram malloc wrong\n");
		
		return ERROR_ITEM_MALLOC;
	}

#ifdef CONFIG_FLASH_TRANSFER
	#ifdef CONFIG_FLASH_WRITE_PROTECT
	kernal_flash_protect(0);
	#endif
	kernel_erase( mtd_master , flash_info_low , flash_info_low->start[i+1] , flash_info_low->start[i+2] - flash_info_low->start[i+1] );
	#ifdef CONFIG_FLASH_WRITE_PROTECT
	kernal_flash_protect(1);
	#endif
	addr = flash_info_low->start[i+1] + CONFIG_MARK_LEN;
#else
	item_dram_repeat = vmalloc( flash_info_low->start[i+1] - flash_info_low->start[i] );
	if ( item_dram_repeat == NULL )
	{		
		printk("item_dram_repeat malloc wrong\n");
		vfree( item_sdram );

		return ERROR_ITEM_MALLOC;
	}
	addr = ( unsigned int )item_dram_repeat;
#endif

	sum = CONFIG_MARK_LEN;

	/* ЧĿת*/
	while( ( sum + ITEM_HEAD_LEN ) <= ( flash_info_low->start[i+1] - flash_info_low->start[i] ) )
	{
		mtd_master->read( mtd_master , flash_info_low->start[i] + sum , READ_ITEM_LEN , &retlen, item_sdram );
		item = ( item_t * ) item_sdram;

		if( item->hdr.avail == 0xff )
		{
#ifdef CONFIG_FLASH_TRANSFER
		#ifdef CONFIG_FLASH_WRITE_PROTECT
			kernal_flash_protect(0);
		#endif
			kernel_write( mtd_master , CONFIG_MARK , flash_info_low->start[i+1] , CONFIG_MARK_LEN );
		#ifdef CONFIG_FLASH_WRITE_PROTECT
			kernal_flash_protect(1);
		#endif
#endif

			break;
		}

		else if( ( item->hdr.avail == ITEM_UNAVAIL ) )
		{
			sum += ITEM_SIZE( item->hdr.len );

			continue;
		}

		else if( item->hdr.avail == ITEM_BAD )
		{
			sum += ITEM_SIZE( 0 );

			continue;
		}

		else if( item->hdr.avail == ITEM_AVAIL )
		{
#ifdef CONFIG_FLASH_TRANSFER
		#ifdef CONFIG_FLASH_WRITE_PROTECT
			kernal_flash_protect(0);
		#endif
			kernel_write( mtd_master , ( unsigned char * )( flash_info_low->start[i] + sum ) , addr , ITEM_SIZE( item->hdr.len ) );
		#ifdef CONFIG_FLASH_WRITE_PROTECT
			kernal_flash_protect(1);
		#endif
#else
			mtd_master->read( mtd_master , flash_info_low->start[i] + sum , ITEM_SIZE( item->hdr.len ) , &retlen, ( unsigned char* )addr );
#endif
			sum += ITEM_SIZE( item->hdr.len );
			addr += ITEM_SIZE( item->hdr.len );
			len += ITEM_SIZE( item->hdr.len );
						
			continue;
		}
#ifdef CONFIGURE_BLOCK_CHECK		
		else
		{  
		    /*ߵ,sumֵӣѭһ쳣*/
		    printk("Error:item_get() line=%d sum = %d  repeat error!!!\n",__LINE__,sum);
			vfree(item_sdram);
            return ERROR_ITEM_NOT_FIND;	
		}
#endif
	}

	/* */ 
#ifdef CONFIG_FLASH_WRITE_PROTECT
	kernal_flash_protect(0);
#endif
	kernel_erase( mtd_master , flash_info_low , flash_info_low->start[i] , flash_info_low->start[i+1] - flash_info_low->start[i] );
#ifdef CONFIG_FLASH_WRITE_PROTECT
	kernal_flash_protect(1);
#endif
	/* Ŀд*/
#ifdef CONFIG_FLASH_TRANSFER
	#ifdef CONFIG_FLASH_WRITE_PROTECT
	kernal_flash_protect(0);
	#endif
	kernel_write( mtd_master , ( char * )( flash_info_low->start[i+1] + CONFIG_MARK_LEN ) , flash_info_low->start[i] + CONFIG_MARK_LEN , len );
	#ifdef CONFIG_FLASH_WRITE_PROTECT
	kernal_flash_protect(1);
	#endif
#else
	#ifdef CONFIG_FLASH_WRITE_PROTECT
	kernal_flash_protect(0);
	#endif
	kernel_write( mtd_master , item_dram_repeat , flash_info_low->start[i] + CONFIG_MARK_LEN , len );
	#ifdef CONFIG_FLASH_WRITE_PROTECT
	kernal_flash_protect(1);
	#endif
#endif
	#ifdef CONFIG_FLASH_WRITE_PROTECT
	kernal_flash_protect(0);
	#endif
	kernel_write( mtd_master , CONFIG_MARK , flash_info_low->start[i] , CONFIG_MARK_LEN );
	#ifdef CONFIG_FLASH_WRITE_PROTECT
	kernal_flash_protect(1);
	#endif
	vfree( item_sdram );
#ifndef CONFIG_FLASH_TRANSFER
	vfree( item_dram_repeat );
#endif

	return ERROR_ITEM_REPEAT_OK;
}

/*=========================================================================
 Function:		flash_update_bin( void )
 Description:		ϵͳеBIN file
 				
 Data Accessed:	/var/image.bin
 Data Updated:	flashе
 
 Input:			
 Output:			
 Return:			0:		ɹ
 				:	ʧ
 Others:
=========================================================================*/

int flash_update_bin( void )
{
	unsigned int			end = 0;
	int					len = 0;
	mm_segment_t		fs;
	long					fp_image_bin = -1;
	char					*buff = NULL;
	flash_info_t			*info;
	struct mtd_info		*mtd;
	struct mtd_part		*part ;
	
	fs = get_fs();
	set_fs (get_ds());

	/* ȡMTDϢ*/
	mtd = get_mtd_device( NULL, 0 );
	part = PART(mtd);

	info = vmalloc( ( unsigned long )sizeof( flash_info_t ) );
	if ( info == NULL )
	{
		printk(KERN_EMERG"info malloc wrong\n");
		return EFAULT;
	}

	/* ȡFlashб*/
	flash_info_get( info , part->master );

	if( ( fp_image_bin = sys_open( BIN_FILE , O_RDONLY , 0 ) ) < 0 )//modify by zhengmingming 20120702
       {
		printk("\nCan't find BIN file\n");
		set_fs (fs);
		vfree( info );		
		return EFAULT;
	}

	buff = vmalloc(1024);
	if( buff == NULL )
	{
		printk("buff malloc wrong\n");
		sys_close( fp_image_bin );
		set_fs ( fs );
		vfree( info );
		return EFAULT;
	}

/*add by songyongbo 20150725 for save mib_rf and mac when update bin start*/
#ifdef BACKUP_ITEM_MIB_RF_MAC
    memset(&stFactoryCfg,0,sizeof(struct FactoryCfg));
	memset(&stsyscfg,0,sizeof(llconfig_syscfg_t));

	/*ȡmib_rfֵ*/
    FactoryCfg_get(&stFactoryCfg);
	/*ȡllconfigĿϢ*/
	llconfig_get_syscfg(&stsyscfg);
#endif
/*add by songyongbo 20150725 for save mib_rf and mac when update bin end*/



	printk("\nErasing flash");

	/*Flashȫ*/
#ifdef CONFIG_FLASH_WRITE_PROTECT
	kernal_flash_protect(0);
#endif	
	kernel_erase( part->master , info , info->start[0] , info->size );
#ifdef CONFIG_FLASH_WRITE_PROTECT
	kernal_flash_protect(1);
#endif
	printk("\nBurning flash");

	/*imageдFlash*/
	end = info->start[0];
#ifdef CONFIG_FLASH_WRITE_PROTECT
	kernal_flash_protect(0);
#endif
	while( ( len = sys_read( fp_image_bin , buff , 1024 )  ) != 0 )
	{	
		kernel_write( part->master , buff , end , len );	
		end += len;

		if( ( end % 0x10000 ) == 0 )
			printk(".");
	}
#ifdef CONFIG_FLASH_WRITE_PROTECT
	kernal_flash_protect(1);
#endif
	sys_close(fp_image_bin);
	set_fs (fs);
	vfree(buff);
	vfree( info );
//modify by zhengmingming
/*add by huangshuangbang 20120602 for save mib_rf and mac when update bin start*/
#ifdef BACKUP_ITEM_MIB_RF_MAC
    FactoryCfg_set(&stFactoryCfg);
    
	/*ǰmacûȥ*/
	llconfig_set_syscfg(&stsyscfg);
#endif	
/*add by huangshuangbang 20120602 for save mib_rf and mac when update bin end*/	
	printk("\nFlash Update Completed\n");

	return 0;
}

/*=========================================================================
 Function:		int flash_update_img( void )

 Description:		ϵͳ
 				
 Calls:			sys_open
 				sys_read
 				sys_close
 				kernel_erase
 				kernel_write
 				sysdata_save
 Data Accessed:	/var/image.img
 Data Updated:	flashе
 
 Input:			
 Output:			
 Return:			0:		ɹ
 				:	ʧ
 Others:
=========================================================================*/

int flash_update_img( void )
{
	update_hdr_t			*update_hdr;
	unsigned int			start = 0 ;
	unsigned int			end = 0;
	int					len = 0;
	mm_segment_t		fs;
	long					fp_image_img = -1;
	char					*buff = NULL;
	flash_info_t			*info;
	struct mtd_info		*mtd;
	struct mtd_part		*part ;
	sys_config_t			*sys_data;

	fs = get_fs();
	set_fs (get_ds());

	/* ȡMTDϢ*/
	mtd = get_mtd_device( NULL, 0 );
	part = PART(mtd);
	
	info = vmalloc( ( unsigned long )sizeof( flash_info_t ) );
	if ( info == NULL )
	{
		printk(KERN_EMERG"info malloc wrong\n");
		return EFAULT;
	}

	/* ȡFlashб*/
	flash_info_get( info , part->master );
	
	sys_data = vmalloc( sizeof( sys_config_t ) );		
	if ( sys_data == NULL )
	{
		printk(KERN_EMERG"sys_config_t malloc wrong\n");
		vfree( info );

		return EFAULT;
	}

	/* ȡײϢ*/
	sysdata_get( sys_data );

	if( (fp_image_img= sys_open(IMG_FILE,O_RDONLY,0)) < 0)
       {
		printk("\nUnable to Open the /var/image.img partition\n");
		set_fs (fs);
		vfree(info);
		vfree(sys_data);
		
		return EFAULT;
	}

	buff = vmalloc(1024);
	if(buff == NULL)
	{
		printk("buff malloc wrong\n");
		sys_close(fp_image_img);
		set_fs (fs);
		vfree(info);
		vfree(sys_data);
				
		return EFAULT;
	}

	/* ȡļͷϢ*/
	update_hdr = vmalloc(sizeof(update_hdr_t));		
	if ( update_hdr == NULL )
	{
		printk("update_hdr malloc wrong\n");
		sys_close(fp_image_img);
		vfree(buff);
		vfree(info);
		vfree(sys_data);

		return EFAULT;
	}

	sys_read( fp_image_img , buff , sizeof(update_hdr_t) ) ;
		
	memcpy( update_hdr , buff , sizeof(update_hdr_t) );
	
	strcpy( sys_data->version ,  update_hdr->version );
	strcpy( sys_data->board_id, update_hdr->board_id);
    
      strcpy( sys_data->swversion, update_hdr->swversion);
	//model_name 
    //strcpy( sys_data->model_name, update_hdr->model_name);

      //region code
      //strcpy( sys_data->region, update_hdr->region);

	/* Added by WuGuoxiang 2015-4-17:ָļͷTBSͷ*/
	sys_lseek(fp_image_img, 0, SEEK_SET);
	/* Add end */

#ifdef CONFIG_DOUBLE_BACKUP

	/*ҵҪдimageFlashʼַ*/
	if( sys_data->image_mark == 0 )
	{
		while( sys_data->layout.zone_offset[ZONE_KERNEL_SECOND] > ( info->start[start] - info->start[0] ) )
		{
			start++;
		}
	}
	else
	{
		while( sys_data->layout.zone_offset[ZONE_KERNEL_FIRST] > ( info->start[start] - info->start[0] ) )
		{
			start++;
		}
	}

	printk("\nErasing flash");
#ifdef CONFIG_FLASH_WRITE_PROTECT
	kernal_flash_protect(0);
#endif
	kernel_erase(part->master,info,info->start[start],update_hdr->image_len);
#ifdef CONFIG_FLASH_WRITE_PROTECT
	kernal_flash_protect(1);
#endif
	printk("\nBurning flash");

	end = info->start[start];
#ifdef CONFIG_FLASH_WRITE_PROTECT
	kernal_flash_protect(0);
#endif
	while( ( len = sys_read(fp_image_img,buff,1024) ) != 0 )
	{			
		kernel_write(part->master,buff,end,len);	
		end += len;

		if( ( end % 0x10000 ) == 0 )
			printk(".");
	}
#ifdef CONFIG_FLASH_WRITE_PROTECT
	kernal_flash_protect(1);
#endif
	/*лimageıʶλ*/
	if( sys_data->image_mark == 0 )
	{
		sys_data->layout.zone_offset[ZONE_ROOTFS_SECOND] = sys_data->layout.zone_offset[ZONE_KERNEL_SECOND] + update_hdr->rootfs_offset - update_hdr->kernel_offset ;
		sys_data->second_image_checksum = update_hdr->image_checksum;
		sys_data->second_image_len = update_hdr->image_len;
		sys_data->image_mark =1;
	}
	else
	{
		sys_data->layout.zone_offset[ZONE_ROOTFS_FIRST] = sys_data->layout.zone_offset[ZONE_KERNEL_FIRST] + update_hdr->rootfs_offset - update_hdr->kernel_offset ;
		sys_data->first_image_checksum = update_hdr->image_checksum;
		sys_data->first_image_len = update_hdr->image_len;
		sys_data->image_mark = 0;
	}

#else

	/*ҵҪдimageFlashʼַ*/
	/* bin ļͷҪȥͷĳ*/
	while(sys_data->layout.zone_offset[ZONE_KERNEL_FIRST] - sizeof(update_hdr_t)> (info->start[start]-info->start[0]))
		start++;
//ͬĿĬϿwatchdogʱرա
#if defined(CONFIG_RTL_WTDOG)
          printk("--flash_update_img---disabe watchdog---\n");
          *((volatile unsigned long *)0xB800311C) = 0xA5000000;    // disabe watchdog
#endif

	printk("\nErasing flash");
#ifdef CONFIG_FLASH_WRITE_PROTECT
	kernal_flash_protect(0);
#endif
	kernel_erase(part->master,info,info->start[start],update_hdr->image_len);
#ifdef CONFIG_FLASH_WRITE_PROTECT
	kernal_flash_protect(1);
#endif
	printk("\nBurning flash");
	end = info->start[start];
#ifdef CONFIG_FLASH_WRITE_PROTECT
	kernal_flash_protect(0);
#endif
	while( ( len = sys_read(fp_image_img,buff,1024) ) != 0 )
	{	
		kernel_write(part->master,buff,end,len);
		end += len;

		if( ( end % 0x10000 ) == 0 )
			printk(".");
	}

	if( ( end % 0x10000 ) != 0 )
		printk(".");
			
#ifdef CONFIG_FLASH_WRITE_PROTECT
	kernal_flash_protect(1);
#endif
	sys_data->layout.zone_offset[ZONE_ROOTFS_FIRST] = sys_data->layout.zone_offset[ZONE_KERNEL_FIRST] + update_hdr->rootfs_offset - update_hdr->kernel_offset ;
	sys_data->first_image_checksum = update_hdr->image_checksum;
	sys_data->first_image_len = update_hdr->image_len;

#endif

	sysdata_save(sys_data); 

	sys_close(fp_image_img);
	set_fs (fs);
	vfree(buff);
	vfree(update_hdr);
	vfree(info);
	vfree(sys_data);

	printk("\nFlash Update Completed\n");

	return 0;
}

/*add by huangshuangbang 20120602 for save mib_rf and mac when update bin start*/

#ifdef CONFIG_APPS_LOGIC_NMRP
/*add by wyh start at 20140624 to add WIFI NMRP upgrade wirte flash interface*/
int flash_nmrp_update_img(int fragmentType, int len, char *buff)
{

	if (fragmentType == NMRP_FIRST_FRAGMENT)
	{
		g_fs = get_fs();
		set_fs (get_ds());

		/* ȡMTDϢ*/
		g_mtd = get_mtd_device( NULL, 0 );
		g_part = PART(g_mtd);
	
		g_info = vmalloc( ( unsigned long )sizeof( flash_info_t ) );
		if ( g_info == NULL )
		{
			printk(KERN_EMERG"info malloc wrong\n");
			return EFAULT;
		}

		/* ȡFlashб*/
		flash_info_get( g_info , g_part->master );
	
		g_sys_data = vmalloc( sizeof( sys_config_t ) );		
		if ( g_sys_data == NULL )
		{
			printk(KERN_EMERG"sys_config_t malloc wrong\n");
			vfree( g_info );

			return EFAULT;
		}

		/* ȡײϢ*/
		sysdata_get( g_sys_data );
		
		/* ȡļͷϢ*/
		g_update_hdr = vmalloc(sizeof(update_hdr_t));		
		if ( g_update_hdr == NULL )
		{
			printk("update_hdr malloc wrong\n");
			vfree(g_info);
			vfree(g_sys_data);

			return EFAULT;
		}
		
		memcpy( g_update_hdr , buff , sizeof(update_hdr_t) );
		
		strcpy( g_sys_data->version ,  g_update_hdr->version );
		strcpy( g_sys_data->board_id, g_update_hdr->board_id);
	    
	    strcpy( g_sys_data->swversion, g_update_hdr->swversion);
	    strcpy( g_sys_data->model_name, g_update_hdr->model_name);

      	//region code
      	//strcpy( sys_data->region, update_hdr->region);

		/*ҵҪдimageFlashʼַ*/
		while(g_sys_data->layout.zone_offset[ZONE_KERNEL_FIRST] > (g_info->start[g_start]-g_info->start[0]))
			g_start++;
		
//ͬĿĬϿwatchdogʱرա
#if defined(CONFIG_RTL_WTDOG)
        printk("--flash_update_img---disabe watchdog---\n");
        *((volatile unsigned long *)0xB800311C) = 0xA5000000;    // disabe watchdog
#endif

		printk("\nErasing flash");
#ifdef CONFIG_FLASH_WRITE_PROTECT
		kernal_flash_protect(0);
#endif
		kernel_erase(g_part->master,g_info,g_info->start[g_start],g_update_hdr->image_len);
#ifdef CONFIG_FLASH_WRITE_PROTECT
		kernal_flash_protect(1);
#endif
		printk("\nBurning flash");
		g_end = g_info->start[g_start];
	}
	else if (fragmentType == NMRP_MIDDLE_FRAGMENT)
	{

#ifdef CONFIG_FLASH_WRITE_PROTECT
		kernal_flash_protect(0);
#endif
		//while( ( len = sys_read(fp_image_img,buff,1024) ) != 0 )
		{	
			kernel_write(g_part->master,buff,g_end,len);
			g_end += len;

			if( ( g_end % 0x10000 ) == 0 )
				printk(".");
		}
		
#ifdef CONFIG_FLASH_WRITE_PROTECT
		kernal_flash_protect(1);
#endif
	}
	else
	{
		g_sys_data->layout.zone_offset[ZONE_ROOTFS_FIRST] = g_sys_data->layout.zone_offset[ZONE_KERNEL_FIRST] + g_update_hdr->rootfs_offset - g_update_hdr->kernel_offset ;
		g_sys_data->first_image_checksum = g_update_hdr->image_checksum;
		g_sys_data->first_image_len = g_update_hdr->image_len;
	
		sysdata_save(g_sys_data); 

		set_fs (g_fs);
		vfree(g_update_hdr);
		vfree(g_info);
		vfree(g_sys_data);
	}

	return 0;
}
/*add by wyh end*/
#endif

/*add by huangshuangbang 20120602 for save mib_rf and mac when update bin end*/

//add by zhengmingming 20120608 repoint the comand line from tbsboot for starting kernel
void repoint_cmdline(char *bootargs)
{
	char *fixed = "console=ttyS0,115200  root=31:2 mtdparts=spi_flash:";
	char *tmp = NULL;
	char *str = bootargs;

	int n[4] = {0};
	int i = 1;
	
	if(NULL == bootargs) 
		return;
	
	tmp = str + strlen(fixed);
	n[0] = simple_strtoul(tmp, NULL, 10);
	tmp = tmp + 1;
	printk("%d\n", n[0]);
	
	while(NULL != (tmp = strstr(tmp + 1, ","))){
		tmp = tmp + 1;
		n[i++] = simple_strtoul(tmp, NULL, 10);
		printk("%d\n", n[i]);
	}
	n[3] = MAX_FLASH_LEN - n[0] -n[1];	
	printk("n[0] = %d, n[1] = %d, n[3] = %d\n", n[0], n[1], n[3]);
	sprintf(str,"%s%d(boot),%d(kernel),%d(rootfs),131072(multi_lang),131072(deflang)", fixed, n[0], n[1], n[3]);
	printk(KERN_EMERG"repoint_cmdline,str:%s\n", str);
}
//add by zhengmingming 20120608 repoint the comand line from tbsboot for starting kernel .end

EXPORT_SYMBOL(item_get);
EXPORT_SYMBOL(item_save);

/*=========================================================================
					File End
=========================================================================*/


